﻿namespace Microscopic_Traffic_Simulator.ViewModels
{
    /// <summary>
    /// Interface for interactions with user.
    /// </summary>
    interface IInteractions
    {
        /// <summary>
        /// Asking whether to save changes or not or if to interrupt the starting action.
        /// </summary>
        /// <returns>True/False/null for Yes/No/Cancel</returns>
        bool? SaveChangesYesNoCancel();

        /// <summary>
        /// Asking which topology file to open for loading.
        /// </summary>
        /// <returns>Path to file.</returns>
        string GetPathToOpenTopologyFile();

        /// <summary>
        /// Asking which topology file the data to be saved into.
        /// </summary>
        /// <returns>Path to file.</returns>
        string GetPathToSaveTopologyFile();

        /// <summary>
        /// Asking which parameters file to open for loading.
        /// </summary>
        /// <returns>Path to file.</returns>
        string GetPathToOpenParametersFile();

        /// <summary>
        /// Asking which paramters file the data to be saved into.
        /// </summary>
        /// <returns>Path to file.</returns>
        string GetPathToSaveParametersFile();

        /// <summary>
        /// Screaming error message.
        /// </summary>
        /// <param name="errorMessage">Text of error message.</param>
        void ScreamErrorMessage(string errorMessage);
    }
}
